namespace ConsoleApp24
{
    internal class Program
    {

       
        public struct Point
        {
            public long X, Y;
            public Point(long x, long y)
            {
                X = x;
                Y = y;
            }
        }

       
        static int ComparePoints(Point a, Point b)
        {
            return a.X == b.X ? a.Y.CompareTo(b.Y) : a.X.CompareTo(b.X);
        }

        
        static long CrossProduct(Point p, Point q, Point r)
        {
            return (q.X - p.X) * (r.Y - p.Y) - (q.Y - p.Y) * (r.X - p.X);
        }

        
        static long Area(List<Point> convexHull)
        {
            int n = convexHull.Count;
            long area = 0;
            for (int i = 0; i < n; i++)
            {
                int j = (i + 1) % n;
                area += convexHull[i].X * convexHull[j].Y - convexHull[j].X * convexHull[i].Y;
            }
            return Math.Abs(area) / 2;
        }

        static void Main(string[] args)
        {

            int N = int.Parse(Console.ReadLine());
            List<Point> points = new List<Point>();

            
            for (int i = 0; i < N; i++)
            {
                var coords = Console.ReadLine().Split().Select(long.Parse).ToArray();
                points.Add(new Point(coords[0], coords[1]));
            }

           
            points.Sort(ComparePoints);

           
            List<Point> convexHull = new List<Point>();

            
            foreach (var p in points)
            {
                while (convexHull.Count >= 2 && CrossProduct(convexHull[convexHull.Count - 2], convexHull[convexHull.Count - 1], p) <= 0)
                    convexHull.RemoveAt(convexHull.Count - 1);
                convexHull.Add(p);
            }

           
            int lowerHullSize = convexHull.Count;
            for (int i = points.Count - 1; i >= 0; i--)
            {
                var p = points[i];
                while (convexHull.Count > lowerHullSize && CrossProduct(convexHull[convexHull.Count - 2], convexHull[convexHull.Count - 1], p) <= 0)
                    convexHull.RemoveAt(convexHull.Count - 1);
                convexHull.Add(p);
            }

            
            convexHull.RemoveAt(convexHull.Count - 1);

            
            long result = Area(convexHull);
            Console.WriteLine(result);

        }
    }
}